/**
 * Created by lei.wang_1 on 2016/7/4.
 */
appModule.directive("inputSave",["pages","utils",function(pages,utils){
    return {
        restrict: "A",
        scope:{
            targetObject:"="
        },
        link: function ($scope,element) {
            element.on("input",function(e){
                $scope.targetObject.content = getTextContent(element.html());
            });
            element.on("keydown",function(e){
               if(e.keyCode == 13){
                   e.preventDefault();
                   document.execCommand("insertLineBreak",false,null);
               }
            });
            element.on("paste",function(e){
                text = (e.originalEvent || e).clipboardData.getData('text');
                if(text.length>0){
                    utils.requestMainWindowMethod("uc.modules.notice.NoticeManager","parseCommentCopyData",[text],function(html){
                        document.execCommand("insertHTML",false, html);
                    });
                }
                e.preventDefault();
            });
            var offClearInput = $scope.$on("clearInput",function(e){
                element.empty();
            });
            function getTextContent(txt){
                return txt.replace(/<br>/g,"\n");
            }

            $scope.$on("$destroy",function(){
                offClearInput();
            });
        }
    }
}]);